% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_count.R
\name{twoarmglmcount.dr}
\alias{twoarmglmcount.dr}
\title{Doubly robust estimators of the coefficients in the contrast regression
 as well as their covariance matrix and convergence information}
\usage{
twoarmglmcount.dr(
  y,
  x.cate,
  time,
  trt,
  ps,
  f1.predictor,
  f0.predictor,
  error.maxNR = 0.001,
  max.iterNR = 150,
  tune = c(0.5, 2)
)
}
\arguments{
\item{y}{Observed outcome; vector of size \code{n}}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates; dimension \code{n} by \code{p.cate}}

\item{time}{Log-transformed person-years of follow-up; vector of size \code{n}}

\item{trt}{Treatment received; vector of size \code{n} units with treatment coded as 0/1}

\item{ps}{Estimated propensity scores for all observations; vector of size \code{n}}

\item{f1.predictor}{Initial predictions of the outcome (expected number of relapses for one unit of exposure time)
conditioned on the covariates \code{x} for treatment group trt = 1; \code{mu_1(x)}, step 1 in the two regression; vector of size \code{n}}

\item{f0.predictor}{Initial predictions of the outcome (expected number of relapses for one unit of exposure time)
conditioned on the covariates \code{x} for treatment group trt = 0; \code{mu_0(x)}, step 1 in the two regression; vector of size \code{n}}

\item{error.maxNR}{A numerical value > 0 indicating the minimum value of the mean absolute
error in Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{0.001}.}

\item{max.iterNR}{A positive integer indicating the maximum number of iterations in the
Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{150}.}

\item{tune}{A vector of 2 numerical values > 0 specifying tuning parameters for the
Newton Raphson algorithm. \code{tune[1]} is the step size, \code{tune[2]} specifies a
quantity to be added to diagonal of the slope matrix to prevent singularity.
Used only if \code{score.method = 'contrastReg'}. Default is \code{c(0.5, 2)}.}
}
\value{
coef: Doubly robust estimators of the regression coefficients \code{delta_0}; vector of size \code{p} + 1 (intercept included)
        vcov: Variance-covariance matrix of the estimated coefficient \code{delta_0}; matrix of size \code{p} + 1 by \code{p} + 1
        converge: Indicator that the Newton Raphson algorithm converged for \code{delta_0}; boolean
}
\description{
Newton-Raphson algorithm is used to solve the estimating equation \code{bar S_n (delta) = 0}
}
