% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_count.R
\name{scorecount}
\alias{scorecount}
\title{Calculate the log CATE score given the baseline covariates and follow-up time for specified scoring method methods}
\usage{
scorecount(
  fit,
  x.cate,
  time,
  score.method = c("boosting", "poisson", "twoReg", "contrastReg", "negBin")
)
}
\arguments{
\item{fit}{List of objects generated from intxcount: outputs of boosting, naive Poisson, two regression, contrast regression, negative binomial}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates; dimension \code{n} (observations) by \code{p.cate} (covariates in the outcome model)}

\item{time}{Log-transformed person-years of follow-up; vector of size \code{n}}

\item{score.method}{A vector of one or multiple methods to estimate the CATE score.
Allowed values are: \code{'boosting'}, \code{'poisson'}, \code{'twoReg'}, \code{'contrastReg'},
\code{'negBin'}. Default specifies all 5 methods.}
}
\value{
score.boosting: Estimated log CATE score for all \code{n} observations with the boosting method; vector of size \code{n}
        score.poisson: Estimated log CATE score for all \code{n} observations with the naive Poisson method; vector of size \code{n}
        score.twoReg: Estimated log CATE score for all \code{n} observations with the two regression method; vector of size \code{n}
        score.contrastReg: Estimated log CATE score for all \code{n} observations with the contrast regression method; vector of size \code{n}
        score.negBin: Estimated log CATE score for all \code{n} observations with the naive Poisson method; vector of size \code{n}
        score = NA if the corresponding method is not called
}
\description{
Based on intxcount results of the CATE coefficients estimated with boosting, naive Poisson, two regression, contrast regression, negative binomial
}
