% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_surv.R
\name{estsurv.multilevel.subgroups}
\alias{estsurv.multilevel.subgroups}
\title{Estimate the ATE of the RMTL ratio and unadjusted hazard ratio in one multilevel subgroup defined by the proportions}
\usage{
estsurv.multilevel.subgroups(
  y,
  d,
  x.cate,
  x.ps,
  x.ipcw,
  trt,
  yf,
  tau0 = tau0,
  score,
  higher.y,
  prop,
  surv.min = 0.025,
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99,
  ipcw.method = "breslow"
)
}
\arguments{
\item{y}{Observed survival or censoring time; vector of size \code{n}.}

\item{d}{The event indicator, normally \code{1 = event, 0 = censored}; vector of size \code{n}.}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates specified in the propensity score model; dimension \code{n} by \code{p.ps}.}

\item{x.ipcw}{Matrix of \code{p.ipw} baseline covariate specified in inverse probability of censoring weighting; dimension \code{n} by \code{p.ipw}.}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1.}

\item{yf}{Follow-up time, interpreted as the potential censoring time; vector of size \code{n} if the potential censoring time is known.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{score}{Estimated log CATE scores for all \code{n} observations from one of the five methods
(random forest, boosting, naive Poisson, two regressions, contrast regression); vector of size \code{n}.}

\item{higher.y}{A logical value indicating whether higher (\code{TRUE}) or
lower (\code{FALSE}) values of the outcome are more desirable. Default is \code{TRUE}.}

\item{prop}{Proportions corresponding to percentiles in the estimated log CATE scores that define subgroups to calculate ATE for;
vector of floats in `[0, 1]` always starting with 0 and ending with 1:
             Each element of \code{prop} represents inclusive cutoffs in the multilevel subgroup and the length of \code{prop}
             is number of categories in the multilevel subgroup}

\item{surv.min}{Lower truncation limit for probability of being censored (positive and very close to 0).}

\item{ps.method}{A character value for the method to estimate the propensity score. Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value (in `[0, 1]`) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in `(0, 1]`) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}

\item{ipcw.method}{The censoring model. Allowed values are: \code{'breslow'} (Cox regression with Breslow estimator of the baseline survivor function),
\code{'aft (exponential)'}, \code{'aft (weibull)'}, \code{'aft (lognormal)'} or \code{'aft (loglogistic)'}. Default is \code{'breslow'}.}
}
\value{
ate.rmtl: estimated ATEs (ratio of RMTL) of all categories in the one multilevel subgroup;
vector of size equal to the length of categories in the multilevel subgroup.
        ate.hr: unadjusted hazard ratio of all categories in the one multilevel subgroup;
        vector of size equal to the length of categories in the multilevel subgroup.
}
\description{
Scores are adjusted to the opposite sign if \code{higher.y} == FALSE; scores stay the same if \code{higher.y} == FALSE;
 this is because estsurv function for multilevel subgroups start from the lowest to the highest adjusted scores,
 and higher adjusted scores should always represent high responders of trt=1
}
