% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzySeparation.R
\name{FuzzySeparation}
\alias{FuzzySeparation}
\title{Fuzzy separation matrix computation}
\usage{
FuzzySeparation(dom, norm, conorm, type, ...)
}
\arguments{
\item{dom}{square matrix representing the dominance degree between pairs of poset elements. Columns and rows names of \code{dom}
are interpreted as the labels of the poset elements. \code{dom} can be computed by using functions such as \code{BLSDominance},
\code{BubleyByesMRP} and \code{ExactMRP}.}

\item{norm}{R-function defining the t-norm}

\item{conorm}{R-function defining the t-conorm}

\item{type}{type of fuzzy Separation to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper", "vertical", "horizontal".
For details on the definition of symmetric, asymmetric, vertical and horizontal separations see Fattore et al. (2024).}

\item{...}{additional types of fuzzy separations to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper", "vertical", "horizontal".}
}
\value{
list of required fuzzy separation matrices.
}
\description{
Starting from a poset dominance matrix, computes fuzzy separation matrices by using the t-norm and t-conorm supplied by the user.
}
\examples{
el <- c("a", "b", "c", "d")

dom_list <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom_list)

BLS <- BLSDominance(pos)

tnorm <- function(x,y){x*y}

tconorm <- function(x,y){x+y-x*y}

FSep <- FuzzySeparation(BLS, norm=tnorm, conorm=tconorm,
            type="symmetric", "asymmetricLower", "vertical")

}
\references{
Fattore, M., De Capitani, L., Avellone, A., and Suardi, A. (2024).
A fuzzy posetic toolbox for multi-criteria evaluation on ordinal data systems.
Annals of Operations Research, https://doi.org/10.1007/s10479-024-06352-3.
}
