% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cp.R
\name{get_cp}
\alias{get_cp}
\title{Get Country Profiles}
\usage{
get_cp(
  country = "all",
  povline = 2.15,
  version = NULL,
  ppp_version = 2017,
  release_version = NULL,
  api_version = "v1",
  format = c("arrow", "rds", "json", "csv"),
  simplify = TRUE,
  server = NULL
)
}
\arguments{
\item{country}{character: A vector with one or more \href{https://wits.worldbank.org/wits/wits/witshelp/content/codes/country_codes.htm}{country ISO 3 codes} or
'all'}

\item{povline}{numeric: Poverty line}

\item{version}{character: Data version. See \code{get_versions()}}

\item{ppp_version}{ppp year to be used}

\item{release_version}{date when the data was published in YYYYMMDD format}

\item{api_version}{character: API version}

\item{format}{character: Response format either of c("rds", "json", "csv")}

\item{simplify}{logical: If TRUE (the default) the response is returned as a
\code{tibble}}

\item{server}{character: Server. For WB internal use only}
}
\value{
If \code{simplify = FALSE}, it returns a list of class "pip_api". If
\code{simplify = TRUE}, it returns a tibble with the requested data. This is the
default. Only for \code{get_aux()}, If \code{assign_tb = TRUE} or character, it
returns TRUE when data was assign properly to .pip env. FALSE, if it was
not assigned.
}
\description{
Get Country Profiles
}
\examples{
\dontrun{
# One country, all years with default ppp_version = 2017
res <- get_cp(country = "AGO")

# All countries, povline = 1.9
res <- get_cp(povline = 1.9)

# All countries and years with default values
res <- get_cp()
}
}
