% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphClust.R
\name{plot.graphclust}
\alias{plot.graphclust}
\title{Plot phylogenetically constrained  clustering}
\usage{
\method{plot}{graphclust}(
  x,
  which = c("selection", "graph", "tree"),
  ask = TRUE,
  colored = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{graphclust} object as produced by \code{\link{graphClust}}.}

\item{which}{a character vector to select plots.
Must be one or more of "\code{selection}", "\code{graph}", "\code{tree}".}

\item{ask}{logical if \code{TRUE} (default), the user is asked before each plot.}

\item{colored}{logical indicating if plots must include colors.}

\item{...}{further arguments to be passed to or from other methods. They are currently ignored in this function.}
}
\description{
This function produces three plots (selectable by \code{which}):
a plot of edges selection based on phylogenetic against trait distances of taxa pairs,
a plot of the graph produced with the selected edges
and a plot of the clustered phylogenetic tree.
}
\examples{
data(navic)
gC <- graphClust(navic, lim.phylo = 1, lim.trait = 2, scale.lim = FALSE)
plot.graphclust(gC, which = "selection", ask = FALSE)
plot.graphclust(gC, which = "graph", ask = FALSE)
plot.graphclust(gC, which = "tree", ask = FALSE)

}
