% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartrack_cod_ratio.R
\name{vartrack_cod_ratio}
\alias{vartrack_cod_ratio}
\title{Calculate the coefficient of detection ratio for two variants}
\usage{
vartrack_cod_ratio(
  phi_v1 = 1,
  phi_v2 = 1,
  gamma_v1 = 1,
  gamma_v2 = 1,
  psi_v1 = 1,
  psi_v2 = 1,
  tau_a = 1,
  tau_s = 1
)
}
\arguments{
\item{phi_v1}{probability that a tested infection caused by variant 1 results in a positive test (sensitivity)}

\item{phi_v2}{probability that a tested infection caused by variant 2 results in a positive test (sensitivity)}

\item{gamma_v1}{probability that a detected infection caused by variant 1 meets some quality threshold}

\item{gamma_v2}{probability that a detected infection caused by variant 2 meets some quality threshold}

\item{psi_v1}{probability that an infection caused by variant 1 is asymptomatic}

\item{psi_v2}{probability that an infection caused by variant 2 is asymptomatic}

\item{tau_a}{probability of testing an asymptomatic infection (any variant); note that this parameter is not required if psi_v1==psi_v2}

\item{tau_s}{probability of testing a symptomatic infection (any variant); note that this parameter is not required if psi_v1==psi_v2}
}
\value{
scalar giving the multiplicative bias of variant 1
}
\description{
This function calculates the coefficient of detection ratio \eqn{C_{V_1}/C_{V_2}} for two variants.
This function assumes that variant 1 is the variant of concern.
This function is specific to the two-variant system.
Parameters not provided are assumed to be equivalent between the two variants.
}
\examples{
vartrack_cod_ratio(phi_v1=0.975, phi_v2=0.95, gamma_v1=0.8, gamma_v2=0.6)

}
\seealso{
Other variant tracking functions: 
\code{\link{vartrack_prob_detect_cont}()},
\code{\link{vartrack_prob_detect_xsect}()},
\code{\link{vartrack_prob_detect}()},
\code{\link{vartrack_prob_prev_xsect}()},
\code{\link{vartrack_prob_prev}()},
\code{\link{vartrack_samplesize_detect_cont}()},
\code{\link{vartrack_samplesize_detect_xsect}()},
\code{\link{vartrack_samplesize_detect}()},
\code{\link{vartrack_samplesize_prev_xsect}()},
\code{\link{vartrack_samplesize_prev}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant tracking functions}
