% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mscale}
\alias{mscale}
\title{Compute the M-Scale of Centered Values}
\usage{
mscale(x, bdp = 0.25, cc, opts = mscale_algorithm_options())
}
\arguments{
\item{x}{numeric values. Missing values are verbosely ignored.}

\item{bdp}{desired breakdown point (between 0 and 0.5).}

\item{cc}{tuning parameters for the chosen rho function.
By default, chosen to yield a consistent estimate for the Normal distribution.}

\item{opts}{a list of options for the M-scale estimation algorithm,
see \code{\link[=mscale_algorithm_options]{mscale_algorithm_options()}} for details.}
}
\value{
the M-estimate of scale.
}
\description{
Compute the M-scale without centering the values.
}
\seealso{
Other functions to compute robust estimates of location and scale: 
\code{\link{mloc}()},
\code{\link{mlocscale}()},
\code{\link{tau_size}()}
}
\concept{functions to compute robust estimates of location and scale}
