% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeReversible.R
\name{makeReversible}
\alias{makeReversible}
\title{Transformations to reversibility}
\usage{
makeReversible(
  mutmat,
  method = c("BA", "MH", "PR"),
  adjust = TRUE,
  afreq = NULL
)
}
\arguments{
\item{mutmat}{A \code{\link[=mutationMatrix]{mutationMatrix()}} or \code{\link[=mutationModel]{mutationModel()}}.}

\item{method}{A character indicating which transformation to use. Either "BA"
(Barker), "MH" (Metropolis-Hastings) or "PR" (preserved rate).}

\item{adjust}{Logical. If TRUE (default), the overall mutation rate is
adjusted to preserve the original rate; see \code{\link[=adjustRate]{adjustRate()}}. Not relevant
for method "PR", which by construction always preserves the overall rate.}

\item{afreq}{A vector of allele frequencies. Extracted from \code{mutmat} if not
provided.}
}
\value{
A reversible mutation matrix with the same allele frequencies.
}
\description{
This function implements three methods for transforming a mutation model
\verb{(M,p)} into a reversible one, \verb{(R,p)}. All methods are based on Metropolis-
Hastings proposal functions.
}
\details{
These transformations may also be applied through the \code{transform} argument of
\code{\link[=mutationMatrix]{mutationMatrix()}} and \code{\link[=mutationModel]{mutationModel()}}.
}
\examples{
m = mutationMatrix("equal", afreq = c(a=0.2, b=0.3, c=0.5), rate = 0.2)
makeReversible(m, "BA")
makeReversible(m, "MH")
makeReversible(m, "PR")

makeReversible(m, "BA", adjust = FALSE)  # rate differs!

# Apply to full model with different female/male rates
mod = mutationModel("equal", afreq = c(a=0.2, b=0.3, c=0.5),
                    rate = list(female = 0.1, male = 0.2))
modR = makeReversible(mod)

}
