% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lattice.pbo.R
\name{dotplot.pbo}
\alias{dotplot.pbo}
\title{PBO in-sample selection dot plot.}
\usage{
\method{dotplot}{pbo}(
  x,
  data = NULL,
  main,
  xlab = "Sorted Study Number (N)",
  ylab = "IS Selection Frequency",
  show_config = TRUE,
  show_grid = TRUE,
  sel_threshold = 0,
  ...
)
}
\arguments{
\item{x}{a \code{pbo} object as returned by \code{\link[pbo]{pbo}}.}

\item{data}{should not be used}

\item{main}{plot title, default computed internally,
passed to \code{\link[lattice]{dotplot}}.}

\item{xlab}{x-axis label with default,
passed to \code{\link[lattice]{dotplot}}.}

\item{ylab}{y-axis label with default,
passed to \code{\link[lattice]{dotplot}}.}

\item{show_config}{whether to show the study dimension annotations,
default TRUE}

\item{show_grid}{whether to show the grid panel, default TRUE}

\item{sel_threshold}{the minimum in-sample frequency subsetting threshold,
default 0; selection frequencies at or below this value will be omitted}

\item{...}{other parameters as passed to \code{\link[lattice]{dotplot}}.}
}
\description{
Draws an annotated dot plot of study selection sorted
by in-sample selection frequency.
}
\seealso{
pbo, histogram.pbo, xyplot.pbo
}
\keyword{backtest}
\keyword{overfitting}
\keyword{pbo}
