% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_delete_principal_mapping}
\alias{kendra_delete_principal_mapping}
\title{Deletes a group so that all users that belong to the group can no longer
access documents only available to that group}
\usage{
kendra_delete_principal_mapping(
  IndexId,
  DataSourceId = NULL,
  GroupId,
  OrderingId = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index you want to delete a group from.}

\item{DataSourceId}{The identifier of the data source you want to delete a group from.

A group can be tied to multiple data sources. You can delete a group
from accessing documents in a certain data source. For example, the
groups "Research", "Engineering", and "Sales and Marketing" are all tied
to the company's documents stored in the data sources Confluence and
Salesforce. You want to delete "Research" and "Engineering" groups from
Salesforce, so that these groups cannot access customer-related
documents stored in Salesforce. Only "Sales and Marketing" should access
documents in the Salesforce data source.}

\item{GroupId}{[required] The identifier of the group you want to delete.}

\item{OrderingId}{The timestamp identifier you specify to ensure Amazon Kendra does not
override the latest \code{DELETE} action with previous actions. The highest
number ID, which is the ordering ID, is the latest action you want to
process and apply on top of other actions with lower number IDs. This
prevents previous actions with lower number IDs from possibly overriding
the latest action.

The ordering ID can be the Unix time of the last update you made to a
group members list. You would then provide this list when calling
\code{\link[=kendra_put_principal_mapping]{put_principal_mapping}}. This ensures
your \code{DELETE} action for that updated group with the latest members list
doesn't get overwritten by earlier \code{DELETE} actions for the same group
which are yet to be processed.

The default ordering ID is the current Unix time in milliseconds that
the action was received by Amazon Kendra.}
}
\description{
Deletes a group so that all users that belong to the group can no longer access documents only available to that group.

See \url{https://www.paws-r-sdk.com/docs/kendra_delete_principal_mapping/} for full documentation.
}
\keyword{internal}
