% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateGradientQuantile.R
\name{simulateGradientQuantile}
\alias{simulateGradientQuantile}
\title{Repeatedly Simulate Sampled Assemblages at some Gradient Value, and Return a Quantile Based on Recovered Gradient Values}
\usage{
simulateGradientQuantile(
  quantileProbs = c(0.95),
  nSamplesSim,
  gradientValue,
  origAbundData,
  kdeRescaled,
  probSpeciesOccur,
  powerRootTransform = 1,
  specimensPerTimestep = 10000,
  nSpecimens
)
}
\arguments{
\item{quantileProbs}{The quantile for which to return on the recovered gradient values from the simulated assemblages. (Technically multiple quantiles can be given, for which a value will be returned for each.}

\item{nSamplesSim}{The number of samples to simulate.}

\item{gradientValue}{The gradient value to simulate assemblages at.}

\item{origAbundData}{The original matrix of abundance data, to be used to
project the simulated data into the same detrended correspondence analysis (DCA) space.}

\item{kdeRescaled}{The list of modeled KDEs for species abundance, output from \code{\link{getSpeciesSpecificRescaledKDE}}.}

\item{probSpeciesOccur}{The output from \code{\link{getProbOccViaPresAbs}}}

\item{powerRootTransform}{The power-root transform to be used on the abundance data before applying the DCA. By default this is 1, which means the data is not transformed at all. Note that the power-root transform is only performed if \code{useTransformedRelAbundance = TRUE}.}

\item{specimensPerTimestep}{The number of specimens returned in a given time-step by \code{getTimestepAbundances}, usually set to an unrealistically high number to represent the true 'unsampled' fossil assemblage.}

\item{nSpecimens}{The number of specimens selected in each individual sample.}
}
\value{
A value for each quantile specified in \code{quantileProbs}. May be multiple values if \code{quantileProbs} is a vector with more than one value.
}
\description{
This function simulates assemblages at a single given gradient value, and returns a specified quantile on the recovered gradient values for the sake of defining an envelope around on recovered gradient values.
}
\details{
This function is most useful with applications like \code{getRecoveredTransitionDuration} which use envelope values to define features of a recovered sequence of gradient values for comparing simulated and empirical data.
}
