% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{The dependency solver}
\alias{The dependency solver}
\title{Find the ideal set of packages and versions to install}
\description{
pak contains a package dependency solver, that makes sure that the
package source and version requirements of all packages are satisfied,
before starting an installation. For CRAN and BioC packages this is
usually automatic, because these repositories are generally in a
consistent state. If packages depend on other other package sources,
however, this is not the case.
}
\details{
Here is an example of a conflict detected:

\if{html}{\out{<div class="sourceCode">}}\preformatted{> pak::pkg_install(c("r-lib/pkgcache@conflict", "r-lib/cli@message"))
Error: Cannot install packages:
  * Cannot install `r-lib/pkgcache@conflict`.
    - Cannot install dependency r-lib/cli@main
  * Cannot install `r-lib/cli@main`.
- Conflicts r-lib/cli@message
}\if{html}{\out{</div>}}

\code{r-lib/pkgcache@conflict} depends on the main branch of \code{r-lib/cli},
whereas, we explicitly requested the \code{message} branch. Since it cannot
install both versions into a single library, pak quits.

When pak considers a package for installation, and the package is given
with its name only, (e.g. as a dependency of another package), then
the package may have \emph{any} package source. This is necessary, because
one R package library may contain only at most one version of a package
with a given name.

pak's behavior is best explained via an example.
Assume that you are installing a local package (see below), e.g.
\code{local::.}, and the local package depends on \code{pkgA} and \code{user/pkgB},
the latter being a package from GitHub (see below), and that \code{pkgA}
also depends on \code{pkgB}. Now pak must install \code{pkgB} \emph{and} \code{user/pkgB}.
In this case pak interprets \code{pkgB} as a package from any package source,
instead of a standard package, so installing \code{user/pkgB} satisfies both
requirements.

Note that that \code{cran::pkgB} and \code{user/pkgB} requirements result a
conflict that pak cannot resolve. This is because the first one \emph{must}
be a CRAN package, and the second one \emph{must} be a GitHub package, and
two different packages with the same cannot be installed into an R
package library.
}
