% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic_batch_api.R
\name{anthropic_get_batch}
\alias{anthropic_get_batch}
\title{Retrieve an Anthropic Message Batch by ID}
\usage{
anthropic_get_batch(
  batch_id,
  api_key = Sys.getenv("ANTHROPIC_API_KEY"),
  anthropic_version = "2023-06-01"
)
}
\arguments{
\item{batch_id}{Character scalar giving the batch ID (for example
\code{"msgbatch_01HkcTjaV5uDC8jWR4ZsDV8d"}).}

\item{api_key}{Optional Anthropic API key. Defaults to
\code{Sys.getenv("ANTHROPIC_API_KEY")}.}

\item{anthropic_version}{Anthropic API version string passed as the
\code{anthropic-version} HTTP header. Defaults to \code{"2023-06-01"}.}
}
\value{
A list representing the Message Batch object, including fields
such as \code{id}, \code{processing_status}, \code{request_counts},
and (after completion) \code{results_url}.
}
\description{
This retrieves the latest state of a Message Batch using its \code{id}.
It corresponds to a \code{GET} request on
\code{/v1/messages/batches/<MESSAGE_BATCH_ID>}.
}
\examples{
\dontrun{
# Requires ANTHROPIC_API_KEY and network access.
# After creating a batch:
batch <- anthropic_create_batch(requests = my_requests)
batch_id <- batch$id

latest <- anthropic_get_batch(batch_id)
latest$processing_status
}

}
