% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_metamodel.R
\name{estimate_decision_sensitivity}
\alias{estimate_decision_sensitivity}
\title{Estimate decision sensitivy DSA using linear metamodel}
\usage{
estimate_decision_sensitivity(df, y, x, y_binomial = FALSE, limit = 0)
}
\arguments{
\item{df}{a dataframe. This dataframe should contain both dependent and independent variables.}

\item{y}{character. Name of the output variable in the dataframe. This will be the dependent variable of the logistic regression model.}

\item{x}{character or a vector for characters. Name of the input variable in the dataframe. This(these) will be the independent variable(s) of the logistic regression model.}

\item{y_binomial}{logical. Is `y` already a binomial outcome? Default is `FALSE.` If `TRUE`, the `y` variable will be used as such, otherwise, the `y` variable will be converted to a binomial variable using the `limit` argument.}

\item{limit}{numeric. Determines the limit when outcomes from `y` are categorised as 'success' (1) or not (0).}
}
\value{
A dataframe with the parameter values of the fitted logistic regression and the decision sensitivity associated with each parameter included in the logistic regression model.
}
\description{
This function performs a logistic regression analysis and determines the decision sensitivity to parameter value using the logistic regression. (STILL IN DEVELOPMENT)
}
\details{
The method for these analyses is described in [Merz et al. 1992](https://doi.org/10.1177%2F0272989X9201200304).
}
\examples{
# Determining decision sensitivity using a non-binomial outcome
data(df_pa)
df_pa$inmb <- df_pa$inc_qaly * 100000 - df_pa$inc_costs
estimate_decision_sensitivity(df = df_pa,
                              y = "inmb",
                              x = c("p_pfsd", "p_pdd"),
                              y_binomial = FALSE
                              )
}
