% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ALD_stats.R
\name{calc_ALD_stats}
\alias{calc_ALD_stats}
\title{Aggregate-level data mean and variance statistics}
\usage{
calc_ALD_stats(strategy, analysis_params)
}
\arguments{
\item{strategy}{A list containing the strategy details, including the family distribution.}

\item{analysis_params}{A list containing:
\itemize{
\item \code{ald} Aggregate-level trial data
\item \code{ref_trt} Treatment labels reference (common; e.g. placebo)
\item \code{ald_comp} Treatment labels comparator
\item \code{scale} A scaling parameter for the calculation. From "log_odds", "risk_difference", "log_relative_risk".
}}
}
\value{
A list containing:
\describe{
\item{\code{mean}}{The marginal treatment effect mean.}
\item{\code{var}}{The marginal treatment effect variance.}
}
}
\description{
Computes the mean and variance of marginal treatment effects for aggregate-level trial data.
}
\examples{
strategy <- list(family = list(family = "binomial"))  # basic version

ald <- data.frame(trt = c("B","C","B","C"),
                  variable = c(NA, NA, "y", "y"),
                  statistic = c("N", "N", "sum", "sum"),
                  value = c(100, 100, 50, 60))

calc_ALD_stats(strategy = strategy,
               list(ald = ald,
                    ref_trt = "C",
                    ald_comp = "B",
                    scale = "log_odds"))

}
\seealso{
\code{\link[=marginal_treatment_effect]{marginal_treatment_effect()}}, \code{\link[=marginal_variance]{marginal_variance()}}
}
