% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.strat.R
\name{print.strat}
\alias{print.strat}
\title{Print stratification object}
\usage{
\method{print}{strat}(x, ...)
}
\arguments{
\item{x}{object of S3 class 'strat'}

\item{...}{further arguments passed to or from other methods}
}
\value{
Returns \code{x} back invisibly and prints tables and statistics to the console
}
\description{
Print method for class "strat".
Prints tables of numbers of control and treated units without strata and in initial and/or improved strata.
Also displays average and maximum standardized mean difference for each stratification.
}
\examples{
# Choose 750 patients and 5 covariates to work with for the example
set.seed(21)
samp <- sample(1:nrow(rhc_X), 750)
cov_samp <- sample(1:26, 5)
ref <- refine(X = rhc_X[samp, cov_samp], z = rhc_X[samp, "z"])
print(ref)
}
