% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_key.R
\name{ors_api_key}
\alias{ors_api_key}
\title{API key management}
\usage{
ors_api_key(key, service = "openrouteservice", username = NULL, keyring = NULL)
}
\arguments{
\item{key}{API key value provided as a character scalar}

\item{service}{Service name, a character scalar.}

\item{username}{Username, a character scalar, or \code{NULL} if the key
is not associated with a username.}

\item{keyring}{For systems that support multiple keyrings, specify
the name of the keyring to use here. If \code{NULL}, then the default
keyring is used. See also \code{\link[keyring:has_keyring_support]{has_keyring_support()}}.}
}
\value{
API Key value when called without \code{key}.
}
\description{
Get/set openrouteservice API key.
}
\details{
To set the key provide it in the \code{key} argument. To retrieve the current
value call the function with \code{key} unset.

Typically the key is saved in the system credential store. Once the key is
defined, it persists in the keyring store of the operating system so it
doesn't need to be set again in a new R session.

Internally the function uses \verb{\link[keyring]\{key_set\}} and
\verb{\link[keyring]\{key_get\}}. The use of keyring package can be bypassed by
providing the key in the environment variable ORS_API_KEY. The value from the
environment variable takes precedence over the value stored in the system
credential store. The default environment variable name used to retrieve the
openrouteservice api key can be overridden by specifying it in
\code{options("openrouteservice.api_key_env")}.
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
