% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_runaway_and_homeless_youth_daily_census.R
\name{nyc_runaway_and_homeless_youth_daily_census}
\alias{nyc_runaway_and_homeless_youth_daily_census}
\title{NYC Runaway and Homeless Youth (RHY) Daily Census}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/Runaway-and-Homeless-Youth-RHY-Daily-Census/5rw7-99k7/about_data>
}
\usage{
nyc_runaway_and_homeless_youth_daily_census(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Runaway and Homeless Youth (RHY) Daily Census data.
}
\description{
Runaway and Homeless Youth (RHY) Daily Census
}
\details{
This data tracks the number of beds available for runaway and homeless youth and young adults as well as the number and percent vacant.
Data include Crisis Shelters, Crisis Shelters HYA (Homeless Young Adults), Transitional Independent Living, and Transitional Independent Living HYA.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_runaway_and_homeless_youth_daily_census(limit = 10)
head(small_sample)

\donttest{
nyc_runaway_and_homeless_youth_daily_census(limit = 5000)
nyc_runaway_and_homeless_youth_daily_census(filters = list(program_type = "Crisis Shelters"))
}
}
