% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_city_record.R
\name{nyc_city_record}
\alias{nyc_city_record}
\title{City Record Online}
\source{
NYC Open Data: <https://data.cityofnewyork.us/City-Government/City-Record-Online/dg92-zbpx/about_data>
}
\usage{
nyc_city_record(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing City Record Online data.
}
\description{
Downloads City Record Online data from NYC Open Data.
}
\details{
The City Record Online (CROL) is a fully searchable database of notices
published in the City Record newspaper, including, but not limited to:
public hearings and meetings, public auctions and sales, solicitations and
awards and official rules proposed and adopted by city agencies.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_city_record(limit = 10)
head(small_sample)

\donttest{
nyc_city_record(limit = 5000)
nyc_city_record(filters = list(short_title = "APPOINTED"))
}
}
