% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullcat_batch.R
\name{nullcat_batch}
\alias{nullcat_batch}
\title{Generate a batch of null matrices using nullcat()}
\usage{
nullcat_batch(x, n_reps = 999L, stat = NULL, n_cores = 1L, seed = NULL, ...)
}
\arguments{
\item{x}{Community matrix (sites × species) or any categorical matrix of integers.}

\item{n_reps}{Number of randomizations to generate. Default is \code{999}.}

\item{stat}{Optional summary function taking a matrix and returning a numeric
statistic. If \code{NULL} (default), the function returns the full set of
randomized matrices.}

\item{n_cores}{Number of compute cores to use for parallel processing. Default is \code{1}.}

\item{seed}{Integer used to seed random number generator, for reproducibility.}

\item{...}{Additional arguments passed to \code{\link[=nullcat]{nullcat()}}
(e.g. \code{method}, \code{n_iter}, \code{output}).}
}
\value{
If \code{stat} is \code{NULL}, returns a 3D array (rows × cols × n_reps).
If \code{stat} is not \code{NULL}, returns a numeric array of statistic values
(dimensionality depends on \code{stat}).
}
\description{
Runs the categorical null model implemented in \code{\link[=nullcat]{nullcat()}} repeatedly,
generating a batch of randomized matrices or, optionally, a batch of
summary statistics computed from those matrices. This is the categorical
analog of \code{quantize_batch()}.
}
\examples{
set.seed(123)
x <- matrix(sample(1:4, 100, replace = TRUE), nrow = 10)

# Generate 99 randomized matrices
nulls <- nullcat_batch(x, n_reps = 99, method = "curvecat", n_iter = 100)

# Or compute a statistic on each
row_sums <- nullcat_batch(x, n_reps = 99, stat = rowSums,
                          method = "curvecat", n_iter = 100)

# Specify multiple cores for parallel processing
nulls <- nullcat_batch(x, n_reps = 99, n_iter = 100, n_cores = 2)

}
