% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nppois.R
\name{plot.nppois}
\alias{plot.nppois}
\title{Plotting a nonparametric Poisson mixture}
\usage{
\method{plot}{nppois}(
  x,
  mix,
  beta,
  col = 2,
  add = FALSE,
  components = c("proportions", "curves", "null"),
  main = "nppois",
  lwd = 1,
  lty = 1,
  xlab = "Data",
  ylab = "Density",
  xlim = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{nppois}.}

\item{mix}{an object of class \code{disc}.}

\item{beta}{the structural parameter (not used for a Poisson
mixture).}

\item{col}{the color of the density curve to be plotted.}

\item{add}{if \code{FALSE}, creates a new plot; if \code{TRUE},
adds the plot to the existing one.}

\item{components}{if \code{proportions} (default), also show the
support points and mixing proportions (in proportional vertical
lines); if \code{curves}, also show the component density
curves; if \code{null}, components are not shown.}

\item{main, lwd, lty, xlab, ylab, xlim}{arguments for graphical
parameters (see \code{par}).}

\item{...}{arguments passed on to function \code{barplot}.}
}
\description{
Function \code{plot.nppois} plots a Poisson mixture,
   along with data.
}
\examples{

mix = disc(pt=c(0,4), pr=c(0.3,0.7))  # a discrete distribution
x = rnppois(200, mix)
plot(x, mix)
 
}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{class}
\keyword{function}
