% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnm.R
\name{hcnm}
\alias{hcnm}
\title{Hierarchical Constrained Newton method}
\usage{
hcnm(
  D,
  p0 = NULL,
  w = 1,
  maxit = 1000,
  tol = 1e-06,
  blockpar = NULL,
  recurs.maxit = 2,
  compact = TRUE,
  depth = 1,
  verbose = 0
)
}
\arguments{
\item{D}{A numeric matrix, each row of which stores the component
density values of an observation.}

\item{p0}{Initial mixture component proportions.}

\item{w}{Duplicity of each row in matrix \code{D} (i.e., that of a
corresponding observation).}

\item{maxit}{Maximum number of iterations.}

\item{tol}{A tolerance value to terminate the
algorithm. Specifically, the algorithm is terminated, if the
increase of the log-likelihood value after an iteration is less
than \code{tol}.}

\item{blockpar}{Block partitioning parameter. If > 1, the number
of blocks is roughly \code{nrol(D)/blockpar}. If < 1, the number
of blocks is roughly \code{nrol(D)^blockpar}.}

\item{recurs.maxit}{Maximum number of iterations in recursions.}

\item{compact}{Whether iteratively select and use a compact subset
(which guarantees convergence), or not (if already done so
before calling the function).}

\item{depth}{Depth of recursion/hierarchy.}

\item{verbose}{Verbosity level for printing intermediate results.}
}
\value{
\item{p}{Computed probability vector.}

\item{convergence}{convergence code. \code{=0} means a success,
   and \code{=1} reaching the maximum number of iterations}

\item{ll}{log-likelihood value at convergence}

\item{maxgrad}{Maximum gradient value.}

\item{numiter}{number of iterations required by the algorithm}
}
\description{
Function \code{hcnm} can be used to compute the MLE
  of a finite discrete mixing distribution, given the component
  density values of each observation. It implements the
  hierarchical CNM algorithm of Wang and Taylor (2013).
}
\examples{

x = rnppois(1000, disc(0:50))    # Poisson mixture
D = outer(x$v, 0:1000/10, dpois)
(r = hcnm(D, w=x$w))
disc(0:1000/10, r$p, collapse=TRUE)

cnm(x, init=list(mix=disc(0:1000/10)), model="p")

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
 likelihood estimate of a mixing distribution. \emph{Journal of
 the Royal Statistical Society, Ser. B}, \bold{69}, 185-198.

Wang, Y. and Taylor, S. M. (2013). Efficient computation of
 nonparametric survival functions via a hierarchical mixture
 formulation. \emph{Statistics and Computing}, \bold{23}, 713-725.
}
\seealso{
\code{\link{cnm}}, \code{\link{nppois}}, \code{\link{disc}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
