% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harwell_Serlin.r
\name{Harwell_Serlin}
\alias{Harwell_Serlin}
\title{Harwell and Serlin Method for Nonparametric ANCOVA}
\usage{
Harwell_Serlin(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate1 + ... + group`.}
}
\value{
A list containing the following components:
\describe{
  \item{regression_equation}{The summary of the fitted linear model.}
  \item{anova}{The ANOVA table from the fitted model.}
  \item{statistics}{The Harwell-Serlin test statistic.}
  \item{df}{The degrees of freedom for the test.}
  \item{p_value}{The p-value of the test.}
  \item{data}{The original data frame with added columns for ranks.}
}
}
\description{
Performs the Harwell and Serlin method using ranked response and covariate variables.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35),
  covariate2 = c(12, 21, 24, 29, 34, 17, 2, 40, 38, 36, 8, 1, 9, 28, 16)
)

# 2. Run the Harwell and Serlin method
results <- Harwell_Serlin(
  formula = response ~ covariate1 + covariate2 + group,
  data = data
)

# 3. View the results
print(results$p_value)
print(paste("Statistic:", results$statistics,"df:", results$df, "P-value:", results$p_value))

}
\references{
Harwell MR, Serlin RCJPB. An empirical study of a proposed test of nonparametric analysis of covariance. 1988;104(2):268.
}
