% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/066_symd_gimg_an.R
\name{symd_gimg_an}
\alias{symd_gimg_an}
\alias{symd_gimg_an.default}
\alias{symd_gimg_an.formula}
\title{Symmetric/dependent Gaussian-image attribute noise}
\usage{
\method{symd_gimg_an}{default}(x, y, level, sortid = TRUE, ...)

\method{symd_gimg_an}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per attribute.}
\item{idnoise}{an integer vector list with the indices of noisy samples per attribute.}
\item{numclean}{an integer vector with the amount of clean samples per attribute.}
\item{idclean}{an integer vector list with the indices of clean samples per attribute.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric/dependent Gaussian-image attribute noise} into a classification dataset.
}
\details{
\emph{Symmetric/dependent Gaussian-image attribute noise} corrupts (\code{level}·100)\% 
of the samples in the dataset.
For each sample, a Gaussian distribution (with matching mean and variance to the original sample) is used to 
generate random attribute values for that sample.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- symd_gimg_an(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- symd_gimg_an(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
L. Huang, C. Zhang, and H. Zhang.
\strong{Self-adaptive training: Beyond empirical risk minimization}.
In \emph{Proceedings of the Advances in Neural Information Processing Systems}, 2020, Vol. 33, pp. 19365–19376.
\url{https://proceedings.neurips.cc/paper/2020/file/e0ab531ec312161511493b002f9be2ee-Paper.pdf}
}
\seealso{
\code{\link{unc_vgau_an}}, \code{\link{symd_rpix_an}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
