% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/008_fra_bdir_ln.R
\name{fra_bdir_ln}
\alias{fra_bdir_ln}
\alias{fra_bdir_ln.default}
\alias{fra_bdir_ln.formula}
\title{Fraud bidirectional label noise}
\usage{
\method{fra_bdir_ln}{default}(x, y, level, sortid = TRUE, ...)

\method{fra_bdir_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Fraud bidirectional label noise} into a classification dataset.
}
\details{
\emph{Fraud bidirectional label noise} randomly selects (\code{level}·100)\% of the samples
from the minority class in the dataset and \code{level}·10 samples from the majority class.
Then, minority class samples are mislabeled as belonging to the majority class and majority class 
samples are mislabeled as belonging to the minority class. In case of ties determining minority and majority classes, 
a random class is chosen among them.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- fra_bdir_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- fra_bdir_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
Z. Salekshahrezaee, J. L. Leevy, and T. M. Khoshgoftaar. 
\strong{A reconstruction error-based framework for label noise detection}. 
\emph{Journal of Big Data}, 8(1):1-16, 2021.
\doi{10.1186/s40537-021-00447-5}.
}
\seealso{
\code{\link{irs_bdir_ln}}, \code{\link{pai_bdir_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
