% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene_heatmap.R
\name{plot_gene_heatmap}
\alias{plot_gene_heatmap}
\title{Plot Gene Expression Heatmap}
\usage{
plot_gene_heatmap(
  phyex_set,
  genes = NULL,
  top_p = NULL,
  top_k = 30,
  std = TRUE,
  show_reps = FALSE,
  cluster_rows = FALSE,
  cluster_cols = FALSE,
  show_gene_age = TRUE,
  show_gene_ids = FALSE,
  gene_annotation = NULL,
  gene_annotation_colors = NULL,
  ...
)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object (BulkPhyloExpressionSet or ScPhyloExpressionSet)}

\item{genes}{Character vector of specific gene IDs to include in the heatmap (default: NULL for auto-selection of dynamic genes)}

\item{top_p}{Numeric value specifying the top proportion of genes to include (default: NULL). Ignored if top_k is specified.}

\item{top_k}{Absolute number of top genes to select (default: 30). Takes precedence over top_p.}

\item{std}{Logical indicating whether to standardize expression values (default: TRUE)}

\item{show_reps}{Logical indicating whether to show replicates or collapsed data (default: FALSE)}

\item{cluster_rows}{Logical indicating whether to cluster genes/rows (default: FALSE)}

\item{cluster_cols}{Logical indicating whether to cluster conditions/columns (default: FALSE)}

\item{show_gene_age}{Logical indicating whether to show gene age annotation (default: TRUE)}

\item{show_gene_ids}{Logical indicating whether to show gene identifiers (default: FALSE)}

\item{gene_annotation}{Data frame with custom gene annotations, rownames should match gene IDs (default: NULL)}

\item{gene_annotation_colors}{Named list of color vectors for custom gene annotations (default: NULL)}

\item{...}{Additional arguments passed to specific methods}
}
\value{
A ggplot object (converted from pheatmap) showing the gene expression heatmap
}
\description{
Create a heatmap showing gene expression patterns across conditions
with optional dendrograms and gene age annotation.
}
\details{
This function creates a comprehensive heatmap visualization of gene expression patterns.
By default, genes are ordered by their expression angle (developmental trajectory).
The function supports clustering of both genes and identities, and can optionally
display gene age (phylostratum) as a colored annotation bar.

For bulk data, the heatmap shows expression across developmental conditions.
For single-cell data, the heatmap shows expression across cell types.

The gene age annotation uses the PS_colours function to create a consistent
color scheme across different myTAI visualizations.

Custom gene annotations can be provided via the \code{gene_annotation} parameter,
which should be a data frame with gene IDs as rownames and annotation categories
as columns. Corresponding colors should be provided via \code{gene_annotation_colors}
as a named list where names match the annotation column names.
}
\examples{
# Basic heatmap with gene age annotation
p1 <- plot_gene_heatmap(example_phyex_set, show_gene_age = TRUE)

# Single-cell heatmap with subset of cells
p2 <- plot_gene_heatmap(example_phyex_set_sc, show_reps = TRUE, max_cells_per_type = 3)

# Custom gene annotation example
gene_ids <- example_phyex_set@gene_ids[1:3]
gene_annot <- data.frame(
  Category = c("High", "Medium", "Low"),
  row.names = gene_ids
)
colors <- list(Category = c("High" = "red", "Medium" = "yellow", "Low" = "blue"))
p3 <- plot_gene_heatmap(example_phyex_set |> select_genes(gene_ids), gene_annotation = gene_annot, 
                       gene_annotation_colors = colors, show_gene_age = FALSE)

}
