% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene_heatmap.R
\name{.plot_gene_heatmap_impl}
\alias{.plot_gene_heatmap_impl}
\title{Shared Gene Heatmap Implementation}
\usage{
.plot_gene_heatmap_impl(
  expression_matrix,
  strata,
  gene_ids,
  num_strata,
  genes = NULL,
  top_p = NULL,
  top_k = 30,
  std = TRUE,
  cluster_rows = FALSE,
  cluster_cols = FALSE,
  show_gene_age = TRUE,
  show_gene_ids = FALSE,
  gene_annotation = NULL,
  gene_annotation_colors = NULL,
  annotation_col = NULL,
  annotation_col_colors = NULL,
  ...
)
}
\arguments{
\item{expression_matrix}{Matrix of expression values (genes x samples)}

\item{strata}{Factor vector of gene phylostrata}

\item{gene_ids}{Character vector of all gene IDs in the dataset (used for phylostratum mapping)}

\item{num_strata}{Integer number of phylostrata}

\item{genes}{Character vector of specific genes to plot. If NULL, uses top dynamic genes}

\item{top_p}{Proportion of most dynamic genes to include (default: NULL). Ignored if top_k is specified.}

\item{top_k}{Absolute number of top genes to select (default: 30). Takes precedence over top_p.}

\item{std}{Logical indicating whether to use standardized expression values (default: TRUE)}

\item{cluster_rows}{Logical indicating whether to cluster genes/rows (default: FALSE)}

\item{cluster_cols}{Logical indicating whether to cluster identities/columns (default: FALSE)}

\item{show_gene_age}{Logical indicating whether to show gene age as row annotation (default: TRUE)}

\item{show_gene_ids}{Logical indicating whether to show gene names (default: FALSE)}

\item{gene_annotation}{Data frame with custom gene annotations, rownames should match gene IDs (default: NULL)}

\item{gene_annotation_colors}{Named list of color vectors for custom gene annotations (default: NULL)}

\item{annotation_col}{Data frame with column annotations (default: NULL)}

\item{annotation_col_colors}{List of colors for column annotations (default: NULL)}

\item{...}{Additional arguments passed to pheatmap::pheatmap}
}
\value{
A ggplot object showing the gene expression heatmap
}
\description{
Internal helper function that contains the shared logic for creating gene heatmaps.
}
\keyword{internal}
