% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nystrom_embedding.R
\name{nystrom_embedding}
\alias{nystrom_embedding}
\title{Nystrom method for out-of-sample embedding}
\usage{
nystrom_embedding(
  new_data,
  landmark_data,
  kernel_function,
  eigenvectors,
  eigenvalues,
  ...
)
}
\arguments{
\item{new_data}{A matrix or data frame containing the new data points to be projected.}

\item{landmark_data}{A matrix or data frame containing the landmark data points used for approximation.}

\item{kernel_function}{A function used to compute the kernel matrix (e.g., a distance function for MDS).}

\item{eigenvectors}{A matrix containing the eigenvectors obtained from the eigendecomposition of the
kernel matrix between the landmark points.}

\item{eigenvalues}{A vector containing the eigenvalues obtained from the eigendecomposition of the
kernel matrix between the landmark points.}

\item{...}{Additional arguments passed to the kernel_function.}
}
\value{
A matrix containing the approximate embedding of the new_data in the data-dependent space.
}
\description{
Approximate the embedding of a new data point using the Nystrom method, which is particularly useful
for large datasets and data-dependent embedding spaces, such as multidimensional scaling (MDS).
}
