% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVR.r
\name{part.mvr.beta}
\alias{part.mvr.beta}
\title{Partition multivariate richness Beta Component}
\usage{
part.mvr.beta(in.mat, in.com, index.rows, index.type = "Sorensen")
}
\arguments{
\item{in.mat}{A record x trait matrix.  Needs to be in matrix format, not as a dataframe}

\item{in.com}{A community x record matrix}

\item{index.rows}{A vector with 2 elements, that gives the row number for the
pair of communities of interest.}

\item{index.type}{specifies which index to use. Options are Sorensen (default) & Jaccard}
}
\value{
\itemize{
\item aa Overlap between the two communities
\item dissimilarity Dissimilarity between the two communities
\item turnover This gives the turnover between the two communities.  To get the percent of dissimilarity due to turnover, divide by total dissimilarity.
\item Bnes Nestedness-related dissimilarity between the two communities.  To get the percent of dissimilarity due to this, divide by total dissimilarity.
}
}
\description{
Function to calculate dissimilarity between a pair of communities, and
partition it into nestedness-related & turnover components  
Either the Sorensen index or the Jaccard index can be used to calculate dissimilarity
}
\examples{
## Partition beta diversity for two species in the iris dataset

# Set up record x trait matrix
ind.mat = iris
ind.mat$Species = NULL
ind.lbl = sprintf("Ind_\%s",seq(1,nrow(iris)))
ind.mat = as.matrix(ind.mat) #Needs to be in matrix format
rownames(ind.mat) = ind.lbl

# Set up community matrix
com.base = iris$Species
pool = rep(1,nrow(iris))
com1 = sapply(com.base, function(x){ifelse(x == "setosa",1,0)})
com2 = sapply(com.base, function(x){ifelse(x == "versicolor",1,0)})
com3 = sapply(com.base, function(x){ifelse(x == "virginica",1,0)})
com.vec = c(pool,com1,com2,com3)
com.lbl = c("pool","com1","com2","com3") 
com.mat = matrix(com.vec, nrow = 4,byrow = TRUE,dimnames = list(com.lbl,ind.lbl))

# Specify the communities to compare
index.rows = c(2,4) #compare species 1 & 3 (+1 due to the pool being the first community)

# Do the diversity partitioning
part.out = part.mvr.beta(ind.mat,com.mat,index.rows,index.type = "Sorensen")
  com.overlap = part.out[[1]]
  #0: no overlap
  com.dis = part.out[[2]]
  #1: complete dissimilarity
  com.turn = part.out[[3]]
  #1: This gives the absolute amount of dissimilarity due to turnover.
  # For percent dissimilarity due to turnover, you need to divide by overall dissimilarity
  com.nest = part.out[[4]]
  #0: This gives the absolute amount of dissimilarity due to nestedness.
  # For percent, divide by total dissimilarity
}
\references{
Baselga, A. 2010. Partitioning the turnover and nestedness components of beta diversity.  Global Ecology and Biogeography 19: 134-143\cr
Baselga, A. 2012. The relationship between species replacement, dissimilarity derived from nestedness, and nestedness.  Global Ecology and Biogeography 21: 1223-1232\cr
Villeger, S. Grenouillet, G., and Brosse, S. 2013.  Decomposing functional Beta-diversity reveals that low functional Beta-diversity is driven by low functional turnover in European fish assemblages.  Global Ecology and Biogeography 22: 671-681.
}
\author{
A.C. Keyel
}
