% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{residuals.brmcoda}
\alias{residuals.brmcoda}
\title{Posterior Draws of Residuals/Predictive Errors}
\usage{
\method{residuals}{brmcoda}(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link[brms:residuals.brmsfit]{residuals.brmsfit}}.}
}
\value{
An \code{array} of predictive error/residual draws. If
  \code{summary = FALSE} the output resembles those of
  \code{\link[brms]{predictive_error.brmsfit}}. If \code{summary = TRUE} the output
  is an N x E matrix, where N is the number of observations and E denotes
  the summary statistics computed from the draws.
}
\description{
Compute posterior draws of residuals/predictive errors
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
               formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                  wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
                                  chain = 1, iter = 500,
                                  backend = "cmdstanr")

  ## extract residuals
  res <- residuals(m)
  head(res)
}}
}
\seealso{
\code{\link[brms:residuals.brmsfit]{residuals.brmsfit}}
}
