% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{msce_numerical}
\alias{msce_numerical}
\title{Numerical solution of the Multi-Stage Clonal Expansion Model}
\usage{
msce_numerical(t, parameterList, innerSteps = 1000L)
}
\arguments{
\item{t}{Each element in a row of \code{t} defines the endpoint of a 
time interval.
The first time interval starts at time \code{0}.
The last element is the time point for which hazard and survival
function are evaluated.
Elements in a row have to be in monotonously increasing order.
In order to achieve a different number of time intervals for
different rows, rows may start with an arbitrary number of zeros
(i.e. time intervals of length zero).}

\item{parameterList}{List of Matrices.
Each list member has to be named. Allowed names are \code{Nnu0},
\code{alphaX}, \code{gammaX}, and \code{nuX} where \code{X}
can be any positive integer value.
The number of stages is deduced from \code{nuX}
with the highest \code{X}.
Matrices \code{Nnu0} and successive \code{nuX} must be provided.
Missing other matrices are assumed to be zero.
For each matrix it has to hold that the number of columns 
must be equal to the ones in \code{t}.
The number of rows can either equal to the number of rows
in \code{t}, or only one row is provided, 
which then is applied to all rows of \code{t}.

Values in matrices \code{Nnu0}, \code{alphaX}, \code{gammaX},
\code{nuX} correspond to parameters for each time interval,
see the figure and explanations in the package vignette.
Here, \code{Nnu0} is the product of \eqn{N}{N} and \eqn{\nu_0}{nu0}
and \eqn{\gamma_X}{gammaX} is defined by
\eqn{\alpha_X-\beta_X}{alphaX-betaX}.}

\item{innerSteps}{Positive integer.
To improve accuracy, each time interval is internally
divided into \code{innerSteps} time intervals of equal length.
Defaults to 1000.
Note, however, that even in the limit of infinite innerSteps,
there will always be a finite discrepancy to the exact result.}
}
\value{
The output list contains all used arguments of the
       \code{parameterList} and vectors of the model results for
       hazard and logarithm of the survival function
       for each row of the input.
}
\description{
This function aims to solve the general multi-stage model 
with piecewise constant parameters approximatively
by integrating the characteristic equations with Euler's method.
For sufficiently small time intervalls, this approximation often 
yields reasonable results.
Small time intervals can either be provided explicitly with many columns
in argument \code{t}.
An alternative is the optional parameter \code{innerSteps}.
}
\details{
\figure{MSCE.jpg}{Schematic depiction of the MSCE model.
        See the package vignette for details.}
}
\examples{
t <-matrix(data=c(10,20,65,10,20,70),nrow=2,byrow=TRUE)
Nnu0 <- matrix(c(0.3,0.7,1),nrow = 1)
nu1  <- matrix(1e-6,nrow=1,ncol=3)
alpha1<- matrix(1,nrow=1,ncol=3)
gamma1<- matrix(c(0.13,0.13,0.13, 0.15,0.15,0.15),nrow=2,byrow=TRUE)
pars = list(Nnu0=Nnu0, nu1=nu1,alpha1=alpha1,gamma1=gamma1) 

msce_numerical(t,pars)
}
\seealso{
\code{\link{tsce}}
}
