% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px_index.R
\name{nso_rebuild_px_index}
\alias{nso_rebuild_px_index}
\title{Rebuild PXWeb index and optionally write to a file}
\usage{
nso_rebuild_px_index(path = NULL, write = !is.null(path))
}
\arguments{
\item{path}{Output path for JSON. If \code{NULL} (default), no file is written.
For package development, use \code{"inst/extdata/px_index.json"}.}

\item{write}{Whether to write JSON to \code{path}. Defaults to \code{TRUE} if \code{path}
is provided, \code{FALSE} otherwise.}
}
\value{
A tibble containing the rebuilt table index.
}
\description{
Crawls the PXWeb API to rebuild the table index. If \code{path} is provided,
the index is written to that file; otherwise only the in-memory index is
refreshed.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
# Rebuild in-memory index only (takes time to crawl API)
\donttest{
idx <- nso_rebuild_px_index()
head(idx)
}
\dontshow{\}) # examplesIf}
}
