% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px_meta.R
\name{nso_dim_values}
\alias{nso_dim_values}
\title{List values for a table dimension}
\usage{
nso_dim_values(tbl_id, dim, labels = c("code", "en", "mn", "both"))
}
\arguments{
\item{tbl_id}{Table identifier (e.g., "DT_NSO_0300_001V2").}

\item{dim}{Dimension name or code (case-insensitive; exact match preferred).}

\item{labels}{One of "code", "en", "mn", or "both" to control returned label columns.}
}
\value{
A tibble with at least \code{code}; may include \code{label_en} and/or \code{label_mn}.
}
\description{
Returns codes and optional labels for a specific dimension.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
values <- nso_dim_values("DT_NSO_0300_001V2", "Year")
head(values)
\dontshow{\}) # examplesIf}
}
