% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{mn_fuzzy_join_by_name}
\alias{mn_fuzzy_join_by_name}
\title{Fuzzy join data to boundaries by name}
\usage{
mn_fuzzy_join_by_name(
  data,
  name_col,
  level = "ADM1",
  boundaries = NULL,
  max_distance = 2,
  method = c("osa", "lv", "jw", "dl")
)
}
\arguments{
\item{data}{Data frame with a name column.}

\item{name_col}{Column in \code{data} containing names.}

\item{level}{Boundary level.}

\item{boundaries}{Optional pre-fetched boundaries.}

\item{max_distance}{Maximum string distance for a match (default 2).}

\item{method}{Distance method passed to \code{stringdist::stringdist}.}
}
\value{
sf with best fuzzy matches joined.
}
\description{
Fuzzy join data to boundaries by name
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
# Join even with minor spelling differences
pop_data <- data.frame(aimag = c("Ulanbatar", "Darhan"), pop = c(1500000, 100000))
sf_joined <- mn_fuzzy_join_by_name(pop_data, "aimag", level = "ADM1")
\dontshow{\}) # examplesIf}
}
