% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.CS}
\alias{test.CS}
\title{multivariate normality test of Cox and Small}
\usage{
test.CS(data, MC.rep = 1000, alpha = 0.05, Points = NULL)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value.}

\item{alpha}{level of significance of the test.}

\item{Points}{number of points to approximate the maximum functional on the unit sphere.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}#' }
}
\description{
Performs the test of multivariate normality of Cox and Small (1978).
}
\details{
The test statistic is \eqn{T_{n,CS}=\max_{b\in\{x\in\mathbf{R}^d:\|x\|=1\}}\eta_n^2(b)},
where \deqn{\eta_n^2(b)=\frac{\left\|n^{-1}\sum_{j=1}^nY_{n,j}(b^\top Y_{n,j})^2\right\|^2-\left(n^{-1}\sum_{j=1}^n(b^\top Y_{n,j})^3\right)^2}{n^{-1}\sum_{j=1}^n(b^\top Y_{n,j})^4-1-\left(n^{-1}\sum_{j=1}^n(b^\top Y_{n,j})^3\right)^2}}.
Here, \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{j=1,\ldots,n}, are the scaled residuals, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error. Note that the maximum functional has to be approximated by a discrete version, for details see Ebner (2012).
}
\examples{
\donttest{test.CS(MASS::mvrnorm(10,c(0,1),diag(1,2)),MC.rep=100)}

}
\references{
Cox, D.R., Small, N.J.H. (1978), Testing multivariate normality, Biometrika, 65:263-272.

Ebner, B. (2012), Asymptotic theory for the test for multivariate normality by Cox and Small, Journal of Multivariate Analysis, 111:368-379.
}
\seealso{
\code{\link{CS}}
}
