% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{MKurt}
\alias{MKurt}
\title{Mardias measure of multivariate sample kurtosis}
\usage{
MKurt(data)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}
}
\value{
value of sample kurtosis in the sense of Mardia.
}
\description{
This function computes the classical invariant measure of multivariate sample kurtosis due to Mardia (1970).
}
\details{
Multivariate sample kurtosis due to Mardia (1970) is defined by
\deqn{b_{n,d}^{(2)}=\frac{1}{n}\sum_{j=1}^n\|Y_{n,j}\|^4,}
where \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}.To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error.
}
\examples{
MKurt(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Mardia, K.V. (1970), Measures of multivariate skewness and kurtosis with applications, Biometrika, 57:519–530.

Henze, N. (2002), Invariant tests for multivariate normality: a critical review, Statistical Papers, 43:467–506.
}
