% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setBevertonHolt.R
\name{getReproductionLevel}
\alias{getReproductionLevel}
\title{Get reproduction level}
\usage{
getReproductionLevel(params)
}
\arguments{
\item{params}{A MizerParams object}
}
\value{
A named vector with the reproduction level for each species.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
The reproduction level is the ratio between the density-dependent
reproduction rate and the maximal reproduction rate.
}
\examples{
getReproductionLevel(NS_params)

# The reproduction level can be changed without changing the steady state:
params <- setBevertonHolt(NS_params, reproduction_level = 0.9)
getReproductionLevel(params)

# The result is the ratio of RDD and R_max
identical(getRDD(params) / species_params(params)$R_max,
          getReproductionLevel(params))
}
