% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixcure.r
\name{summary.mixcure}
\alias{summary.mixcure}
\title{Summary method for mixture cure models}
\usage{
\method{summary}{mixcure}(object, R = 100, index = 1:2, ...)
}
\arguments{
\item{object}{A mixcure object}

\item{R}{the number of boot samples required to calculate bootstrap
variances.}

\item{index}{An argument used in censboot function in boot package to
specify the columns in data that store survival times and censoring
indicators}

\item{...}{other parameters to be passed into print function}
}
\value{
A modified mixcure object with extra components:
\item{varboot}{a censboot object}
\item{stderr}{standard errors of parameters in mixcure}
\item{R}{the number of bootstrap samples used}
}
\description{
Summary function will calculate bootstrap variances of the estimates in a
mixcure fit if it detects that the variances do not exist. Then it will print
estimates, their standard errors, z-scores and p-values from normal distribution
}
\details{
censboot in boot package is called to calculate bootstrap variances
}
\examples{

data(leukaemia)
# To reduce running time of this example, R is set to 2.
summary(mixcure(Surv(time, cens) ~ transplant, ~ transplant,
data = leukaemia, savedata = TRUE), R = 2)

}
\seealso{
mixcure
}
\author{
Yingwei Peng
}
