% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mar.R
\name{mar}
\alias{mar}
\title{Missing at random (MAR) test}
\usage{
mar(data, debug = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{debug}{A logical value used only for unit testing.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}:
\item{missing}{Column of M with missing data}
\item{p_value}{Smallest p-value of the logistic regressions}
\item{explanatory}{Variable corresponding to \code{p_value}}
\item{p_values}{The p-values of the logistic regressions}
\item{variables}{Variables corresponding to \code{p_values}}
\item{combined}{Paired \code{p_values} and \code{variables} for easier
interpretation}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\code{mar()} performs multiple logistic regressions to test for MAR.
The null hypothesis for each is that the data are not MAR.
}
\details{
In the following, each column of M with missing data is regressed on
D_obs. Each regression produces a vector of p-values (one for each
variable in D_obs). The smallest p-value is the most important. This
is because missing data need only be dependent on one observed variable
for the data to be MAR. If each reported smallest p-value is significant,
the data is MAR. See \code{vignette("background")} for definitions of M and
D_obs.
}
\examples{
mar(healthcheck)
}
