% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-sequence.R
\name{gseq.extract}
\alias{gseq.extract}
\title{Returns DNA sequences}
\usage{
gseq.extract(intervals = NULL)
}
\arguments{
\item{intervals}{intervals for which DNA sequence is returned}
}
\value{
An array of character strings representing DNA sequence.
}
\description{
Returns DNA sequences for given intervals
}
\details{
This function returns an array of sequence strings for each interval from
'intervals'. If intervals contain an additional 'strand' column and its
value is '-1', the reverse-complementary sequence is returned.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals(c(1, 2), 10000, 10020)
gseq.extract(intervs)

}
\seealso{
\code{\link{gextract}}
}
\keyword{~DNA}
\keyword{~extract}
\keyword{~sequence}
