% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_getInformation.R
\name{mc_getInformation}
\alias{mc_getInformation}
\title{Getting information about model parameters}
\usage{
mc_getInformation(list_initial, list_power_fixed, n_resp)
}
\arguments{
\item{list_initial}{A list of initial values.}

\item{list_power_fixed}{A list of logical specyfing if the power
parameters should be estimated or not.}

\item{n_resp}{A number specyfing the nmber of response variables.}
}
\value{
A list containing information about the number of model parameters:
\describe{
  \item{n_betas}{A list with the number of regression parameters
  (\eqn{\beta}) for each response variable.}
  \item{n_taus}{A list with the number of dispersion parameters
  (\eqn{\tau}) for each response variable.}
  \item{n_power}{A list with the number of power parameters for each
  response variable, accounting for fixed parameters.}
  \item{n_rho}{An integer giving the number of correlation parameters.}
  \item{n_cov}{An integer giving the total number of covariance-related
  parameters, including power, dispersion, and correlation parameters.}
}
}
\description{
This computes all information required about the number
    of model parameters.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
