% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wwtp_functions.R
\name{map_wwtp_columns}
\alias{map_wwtp_columns}
\title{Map WWTP Column Names to Standard Format}
\usage{
map_wwtp_columns(raw_data, nutrient, custom_mapping = NULL)
}
\arguments{
\item{raw_data}{Data frame. Raw WWTP data}

\item{nutrient}{Character. "nitrogen" or "phosphorus"}

\item{custom_mapping}{Named list. Custom column mappings (optional)}
}
\value{
Named list with column mappings
}
\description{
Create mapping between EPA WWTP data column names and standardized format.
Handles various EPA data formats across different years.
}
\examples{
\dontrun{
mapping <- map_wwtp_columns(raw_wwtp_data, "nitrogen")

# Custom mapping for different format
custom_map <- list(facility_name = "Plant_Name",
                  pollutant_load = "Annual_Load_kg")
mapping <- map_wwtp_columns(raw_data, "nitrogen", custom_map)
}

}
