% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Model.R
\docType{class}
\name{OrderedModel-class}
\alias{OrderedModel-class}
\title{Class OrderedModel}
\description{
An S4 class to represent inputs to the Ordered allocation procedure
}
\section{Slots}{

\describe{
\item{\code{obs}}{an ObsLulcRasterStack object}

\item{\code{ef}}{an ExpVarRasterList object}

\item{\code{models}}{a PredictiveModelList object}

\item{\code{time}}{numeric vector of timesteps over which simulation will occur}

\item{\code{demand}}{matrix containing demand scenario}

\item{\code{hist}}{RasterLayer showing land use history or NULL}

\item{\code{mask}}{RasterLayer showing masked areas or NULL}

\item{\code{neighb}}{NeighbRasterStack object or NULL}

\item{\code{categories}}{numeric vector of land use categories}

\item{\code{labels}}{character vector corresponding to \code{categories}}

\item{\code{rules}}{matrix with land use change decision rules}

\item{\code{nb.rules}}{numeric with neighbourhood decision rules}

\item{\code{order}}{numeric vector of land use categories in the order that change
should be allocated}

\item{\code{params}}{list with model parameters}

\item{\code{output}}{RasterStack containing simulated land use maps or NULL}
}}

