% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_proj_inter.R
\name{render_proj_inter}
\alias{render_proj_inter}
\title{Modification of the 'render_proj' Function of 'tourr'}
\usage{
render_proj_inter(
  data,
  prj,
  half_range = NULL,
  axis_labels = NULL,
  obs_labels = NULL,
  limits = 1,
  position = "center"
)
}
\arguments{
\item{data}{matrix, or data frame containing numeric columns,
should be standardized to have mean 0, sd 1}

\item{prj}{projection matrix}

\item{half_range}{for scaling in the display, by default calculated from the data}

\item{axis_labels}{of the axes to be displayed}

\item{obs_labels}{labels of the observations to be available for interactive mouseover}

\item{limits}{value setting the lower and upper limits of
projected data, default 1}

\item{position}{position of the axes: center (default),
bottomleft or off}
}
\value{
list containing projected data, circle and segments for axes
}
\description{
Modification of the render_proj() function of tourr so that the half_range is
calculated with max(sqrt(rowSums(data^2))) or can be provided as argument.
}
\examples{
library(tourr)
data("flea", package = "tourr")
flea_std <- apply(flea[,1:6], 2, function(x) (x-mean(x))/sd(x))
prj <- tourr::basis_random(ncol(flea[,1:6]), 2)
p <- render_proj_inter(flea_std, prj)

}
