% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_histories.R
\name{get_local_history}
\alias{get_local_history}
\title{Get Local Tour History}
\usage{
get_local_history(data, starting_projection)
}
\arguments{
\item{data}{the dataset to calculate the projections with. In practice
only the two first rows of the dataset are provided as the actual data is not
needed.}

\item{starting_projection}{the initial projection one wants to initiate the
local tour from}
}
\value{
history object containing the projections of the requested tour
}
\description{
Returns a local tour based on currently displayed projection(s) to the
'python' backend. This local tour is generated with the 'tourr' functions
'save_history' and 'local_tour'.
}
\examples{
library(tourr)
data("flea", package = "tourr")
flea <- flea[-7]
prj <- tourr::basis_random(ncol(flea), 2)
get_local_history(flea, prj)

}
