% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library_call_linter.R
\name{library_call_linter}
\alias{library_call_linter}
\title{Library call linter}
\usage{
library_call_linter(allow_preamble = TRUE)
}
\arguments{
\item{allow_preamble}{Logical, default \code{TRUE}. If \code{FALSE},
no code is allowed to precede the first \code{library()} call,
otherwise some setup code is allowed, but all \code{library()}
calls must follow consecutively after the first one.}
}
\description{
This linter covers several rules related to \code{\link[=library]{library()}} calls:
}
\details{
\itemize{
\item Enforce such calls to all be at the top of the script.
\item Block usage of argument \code{character.only}, in particular
for loading packages in a loop.
\item Block consecutive calls to \code{suppressMessages(library(.))}
in favor of using \code{\link[backports:suppressWarnings]{backports::suppressMessages()}} only once to suppress
messages from all \code{library()} calls. Ditto \code{\link[=suppressPackageStartupMessages]{suppressPackageStartupMessages()}}.
}
}
\examples{
# will produce lints

code <- "library(dplyr)\nprint('test')\nlibrary(tidyr)"
writeLines(code)
lint(
  text = code,
  linters = library_call_linter()
)

lint(
  text = "library('dplyr', character.only = TRUE)",
  linters = library_call_linter()
)

code <- paste(
  "pkg <- c('dplyr', 'tibble')",
  "sapply(pkg, library, character.only = TRUE)",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = library_call_linter()
)

code <- "suppressMessages(library(dplyr))\nsuppressMessages(library(tidyr))"
writeLines(code)
lint(
  text = code,
  linters = library_call_linter()
)

# okay
code <- "library(dplyr)\nprint('test')"
writeLines(code)
lint(
  text = code,
  linters = library_call_linter()
)

code <- "# comment\nlibrary(dplyr)"
lint(
  text = code,
  linters = library_call_linter()
)

code <- paste(
  "foo <- function(pkg) {",
  "  sapply(pkg, library, character.only = TRUE)",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = library_call_linter()
)

code <- "suppressMessages({\n  library(dplyr)\n  library(tidyr)\n})"
writeLines(code)
lint(
  text = code,
  linters = library_call_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
