% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last.R
\name{write_last}
\alias{write_last}
\alias{save_last}
\title{Write the last value to disk}
\usage{
write_last(file = tempfile(), x = .Last.value, ...)

save_last(file = tempfile(), x = .Last.value, ...)
}
\arguments{
\item{file}{File or connection to write to.}

\item{x}{The object to write, usually left as \link[base:Last.value]{base::.Last.value}.}

\item{...}{Additional arguments passed to the writing function (see Details).}
}
\value{
The created file path, invisibly.
}
\description{
The value of the internal evaluation of a top-level R expression is always
assigned to \code{.Last.value} before further processing (e.g., printing).
}
\details{
Four types of files are written, based on object class:
\enumerate{
\item For data frames, a tab-separated file via \code{\link[readr:write_delim]{readr::write_tsv()}}.
\item For vectors, a newline-separated file via \code{\link[readr:read_lines]{readr::write_lines()}}.
\item For ggplots, a raster image (by default) via \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.
\item For other objects, an uncompressed data file via \code{\link[readr:read_rds]{readr::write_rds()}}.
}
}
