% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terser.R
\name{terser}
\alias{terser}
\title{Minify JavaScript code using Terser}
\usage{
terser(input, options = NULL)
}
\arguments{
\item{input}{Either a path to a file or a character string containing the JavaScript code to be minified.}

\item{options}{A list of options to pass to Terser for minification.
See the \href{https://terser.org/docs/api-reference/#minify-options}{Terser documentation} for available options.}
}
\value{
A list containing the minified code and any warnings or errors.
}
\description{
Uses the Terser JavaScript library to minify JavaScript code. Note that the
first time this function is called, it will load the terser library into the JavaScript context,
which may take a few seconds. Subsequent calls will be faster.
}
\examples{
js_code <- "function add(a, b) { return a + b; }"
terser(js_code, list(sourceMap = TRUE))

}
