% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_tools.R
\name{distrhelpers}
\alias{distrhelpers}
\alias{get_moment_methods}
\alias{get_class_abbr}
\alias{get_distr_class}
\alias{s4_to_list}
\alias{get_params}
\alias{get_unknown_params}
\alias{update_params}
\title{Distribution Handling Helpers}
\usage{
get_moment_methods(x)

get_class_abbr(distr)

get_distr_class(distr)

s4_to_list(distr)

get_params(distr, list = TRUE)

get_unknown_params(distr, list = TRUE)

update_params(distr, prm, i)
}
\arguments{
\item{x, distr}{an object of class \code{Distribution}.}

\item{list}{logical. Should a list be returned? If \code{FALSE}, the return object
is wrapped in \code{unlist()}.}

\item{prm, i}{A list containing three elements (\code{name}, \code{pos}, \code{val}) and the
i-th element of \code{val} to be updated as the new parameter. See
\code{small_metrics()}.}
}
\value{
Depends on the function. See Details.
}
\description{
This set of functions help handle the distribution classes. See Details.
}
\section{Functions}{
\itemize{
\item \code{get_moment_methods()}: Returns a character vector with the available moment
methods for the distribution.

\item \code{get_class_abbr()}: Turns the S4 class in the name (character) used in
the usual \code{stats} dpqr syntax.

\item \code{get_distr_class()}: Turns the distribution name from a character to an
S4 class.

\item \code{s4_to_list()}: Turns an S4 distr object to a list.

\item \code{get_params()}: Get the parameters of a distribution as a list.

\item \code{get_unknown_params()}: Get the unknown parameters of a distribution as a
list.

\item \code{update_params()}: Update the distribution parameters. Returns the
distribution object. Used inside the \code{small_metrics()} and \code{large_metrics()}
functions.

}}
\seealso{
\code{\link[=small_metrics]{small_metrics()}}, \code{\link[=large_metrics]{large_metrics()}}
}
\keyword{internal}
